<!DOCTYPE html>
<html lang="en">
    <head>
        <?php define('TITLE', 'Basic Solder Changelog Maker'); require '../../common.php';
            require_once SITE_ROOT . 'includes/header.php';
        ?>
    </head>
    <body>
        <?php include SITE_ROOT . 'includes/menu.php'; ?>
        <div class="container padding-bottom-md">
            <h1><?php echo TITLE; ?></h1>
            <form action="changelog" method="POST">
                <div class="row">
                    <div class="col-md-6">
                        <label for="api">Solder API Location</label>
                        <input id="api" name="api" class="form-control" type="url" value="<?php echo isset($_COOKIE['_api']) ? $_COOKIE['_api'] : ""; ?>" placeholder="Enter the modpack API" />
                        <p class="help-block">Example: http://example.com/api/modpack. A trailing slash is not required.</p>
                    </div>
                    <div class="col-md-6">
                        <label for="modslug">Modpack Slug</label>
                        <input id="modslug" name="modslug" class="form-control" type="text" value="<?php echo isset($_COOKIE['_modslug']) ? $_COOKIE['_modslug'] : ""; ?>" placeholder="Enter the modpack slug" />
                        <p class="help-block">Example: my-modpack. A trailing slash is not required.</p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="oldvn">Last Build No.</label>
                        <input id="oldvn" name="oldvn" class="form-control" type="text" placeholder="Enter last build (if any)" />
                        <p class="help-block">This can be left blank if no previous build exists.</p>
                    </div>
                    <div class="col-md-6">
                        <label for="newvn">Current Build No.</label>
                        <input id="newvn" name="newvn" class="form-control" type="text" placeholder="Enter current build" />
                        <p class="help-block">This cannot be left blank!</p>
                    </div>
                </div>
                <label>Show Section</label>
                <div class="form-group">
                    <label class="checkbox-inline">
                        <input id="show-updated" name="show-updated" type="checkbox" value="1" checked /><span class="chlog-updated">Updated</span>
                    </label>
                    <label class="checkbox-inline">
                        <input id="show-added" name="show-added" type="checkbox" value="1" checked /><span class="chlog-added">Added</span>
                    </label>
                    <label class="checkbox-inline">
                        <input id="show-removed" name="show-removed" type="checkbox" value="1" checked /><span class="chlog-removed">Removed</span>
                    </label>
                </div>
                <button class="btn btn-default" type="submit">Submit</button>
            </form>
        </div>
        <?php require_once SITE_ROOT . 'includes/footer.php'; ?>
    </body>
</html>