function validate() {
	var messages = [];

	if($("#path").val() == "") {
		messages.push("The mod repository path must be entered.");
		$("#path").focus();
	}

	if($("#modslug").val() == "") {
		messages.push("The modslug must be entered.");
		$("#modslug").focus();
	}

	if($("#modversion").val() == "") {
		messages.push("The mod version must be entered.");
		$("#modversion").focus();
	}

	if($("#file").val() == "") {
		messages.push("A file to upload must be selected.");
	}

	if($("#other").is(":checked") && $("#otherjar").val() == "") {
		messages.push("A directory name must be entered if \"other\" is selected.");
		$("#otherjar").focus();
	}

	if(messages.length > 0) {
		// There were issues; compile a list of messages and alert user
		alertMessages = "";
		for(i = 0; i < messages.length; i++) {
			alertMessages += "[ ! ] " + messages[i] + "\n";
		}
		alert(alertMessages);
		return false;
	} else {
		// Everything was uploaded; show loading indicator while file uploads
		var loader = $("body").loadingIndicator().data("loadingIndicator");
		loader.show();
		$('#upload').load(function() {
			loader.hide();
			alert("The file(s) were successfully uploaded.");
			location.reload();
			return true;
		});
	}
}