<?php

require_once 'config.php';

$path = $_POST["path"];
$modname = $_POST["modname"];
$modslug = $_POST["modslug"];
$version = $_POST["modversion"];
$file = $_FILES["file"];
$filetype = $_POST["type"];
$custom = $_POST["otherjar"];

setcookie('_path', $path, time() + 60 * 60 * 24 * 30, '/', COOKIE_DOMAIN, false, true);
setcookie('_modname', $modname, time() + 60 * 60 * 24 * 30, '/', COOKIE_DOMAIN, false, true);
setcookie('_modslug', $modslug, time() + 60 * 60 * 24 * 30, '/', COOKIE_DOMAIN, false, true);
setcookie('_custom', $custom, time() + 60 * 60 * 24 * 30, '/', COOKIE_DOMAIN, false, true);

define("SEP", DIRECTORY_SEPARATOR);
define("MODE", 0755);

// Simulates a file upload without actually doing anything
// Make sure this is TRUE when testing!
define("SIMULATE_ONLY", false);

function makeDirectory($path) {
    if(!SIMULATE_ONLY) {
        if(!is_dir($path)) {
            if(!mkdir($path)) {
                throw new Exception("Unable to create mod directory.");
            }
        }
    } else {
        echo "<p>[SIMULATION] Creating directory for mod: " . $path . "</p>";
    }
}

function createZip($src, $dst, $include_dir = false) {
    if(!extension_loaded('zip')) {
        throw new Exception("The PHP zip extension is not loaded.");
    }

    if(!file_exists($src)) {
        throw new Exception("The source file could not be found.");
    }

    // Overwrite file if it exists at destination
    if(!SIMULATE_ONLY) {
        if(file_exists($dst)) {
            unlink ($dst);
        }

        $zip = new ZipArchive();
        if(!$zip->open($dst, ZIPARCHIVE::CREATE)) {
            return false;
        }

        $src = str_replace('\\', '/', realpath($src));

        if(is_dir($src) === true) {
            // Create array of files to be uploaded
            $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($src), RecursiveIteratorIterator::SELF_FIRST);

            if($include_dir) {
                $arr = explode("/",$src);
                $maindir = $arr[count($arr)- 1];

                $src = "";
                for($i = 0; $i < count($arr) - 1; $i++) { 
                    $src .= '/' . $arr[$i];
                }

                $src = substr($src, 1);
                $zip->addEmptyDir($maindir);
            }

            // Add each file in the array to the zip file
            foreach ($files as $file) {
                // Process Windows file paths
                $file = str_replace('\\', '/', $file);

                // Ignore "." and ".." directories
                if(in_array(substr($file, strrpos($file, '/') + 1), array('.', '..'))) { continue; }

                $file = realpath($file);
                if(is_dir($file) === true) {
                    $zip->addEmptyDir(str_replace($src . '/', '', $file . '/'));
                } else if(is_file($file) === true) {
                    $zip->addFromString(str_replace($src . '/', '', $file), file_get_contents($file));
                }
            }
        }

        else if (is_file($src) === true) {
            $zip->addFromString(basename($src), file_get_contents($src));
        }

        return $zip->close();
    }
}

/*
* Packages the mod jar within its proper folder and zip file
* Folder types: /mods, /config, /bin
*/
function packageModJar($path, $type, $file, $modslug, $version) {
    // Create a temp folder at zip destination
    $basepath = $path . SEP . $type;
    if(!SIMULATE_ONLY) {
        if(!is_dir($basepath)) {        
            mkdir($basepath);
        }
    } else {
        echo "<p>[SIMULATION] Creating temp directory: " . $basepath . "</p>";
    }

    // If the file is already a zip file, simply move it to the proper directory
    // Zip files usually start with 0x504B ("PK" in ASCII)
    $fhandle = fopen($file['tmp_name'], "r");
    $metadata = fread($fhandle, 2);

    // Check that the uploaded file has a proper zip structure and ends in the .zip extension
    if($metadata === "PK" && substr($file['name'], -4) === ".zip") {
        if(!SIMULATE_ONLY) {
            move_uploaded_file($file['tmp_name'], $path . SEP . $modslug . "-" . $version . ".zip");
        } else {
            "<p>[SIMULATION] Moving uploaded ZIP file to mod directory: " . $file['tmp_name'] . "</p>";
        }
    } else {
        // Uploaded file is not a ZIP, create one and move it
        if(!SIMULATE_ONLY) {
            // Move zip contents to temp folder and create zip from contents
            move_uploaded_file($file['tmp_name'], $basepath . SEP . $file['name']);
            createZip($basepath, $path . SEP . $modslug . '-' . $version . '.zip', true);
        } else {
            echo "<p>[SIMULATION] Moving uploaded file to temp directory.</p>";
            echo "<p>[SIMULATION] Creating ZIP archive: " . $path . SEP . $modslug . '-' . $version . '.zip' . "</p>";
        }
    }

    fclose($fhandle);

    //Removes the temp directory and all files inside it
    exec("rm -rf {$basepath}");

    // File is uploaded; return true
    if(file_exists($path . SEP . $modslug . '-' . $version . '.zip')) {
        return true;
    } else {
        return false;
    }
}

function writeToDatabase($path, $modslug, $version) {
    if(!SIMULATE_ONLY) {
        global $con, $modname;
        $md5 = md5_file($path . SEP . $modslug . SEP . $modslug . "-" . $version . ".zip");
        $time = date("Y-m-d h:i:s");

        $query = $con->query("SELECT * FROM " . PREFIX . "mods WHERE name = '$modslug'") or exit("MySQL error with code {$con->errno}: {$con->error}");
        $result = $query->fetch_assoc();
        
        // Check if the requested modslug record exists in the database
        if($query->num_rows > 0) {
            $query = $con->query("SELECT * FROM " . PREFIX . "modversions WHERE mod_id = '$result[id]' AND version = '$version'");
            if($query->num_rows > 0) {
                // Mod version exists so we exit
                exit("The uploaded version already exists.");
            } else {
                // The modslug exists but the version does not so we insert a new version
                $insert = $con->query("INSERT INTO " . PREFIX . "modversions (mod_id, version, md5, created_at, updated_at) VALUES ('$result[id]', '$version', '$md5', '$time', '$time')") or exit("MySQL error with code {$con->errno}: {$con->error}");
            }
        } else {
            if($modname == "") {
                throw new Exception("Cannot add new mod without entering a name.");
            }
            // The modslug does not exist in the system; create a new mod entry then add the version
            $create = $con->query("INSERT INTO " . PREFIX . "mods (name, created_at, updated_at, pretty_name) VALUES ('$modslug', '$time', '$time', '$modname')") or exit("MySQL error with code {$con->errno}: {$con->error}");
            $insert = $con->query("INSERT INTO " . PREFIX . "modversions (mod_id, version, md5, created_at, updated_at) VALUES ('$result[id]', '$version', '$md5', '$time', '$time')") or exit("MySQL error with code {$con->errno}: {$con->error}");
        }

        $con->close();
    } else {
        echo "<p>[SIMULATION] Writing new info to database tables.</p>";
    }
}

function upload($path, $modslug, $version, $file, $filetype, $custom) {
    global $modslug, $uploadExists;

    if(empty($modslug)) {
        exit("Modslug must be entered.");
    }

    if($filetype === "other") {
        $filetype = $custom;
    }

    $finalpath = $path . SEP . $modslug;
    makeDirectory($finalpath);
    packageModJar($finalpath, $filetype, $file, $modslug, $version);

    if(!SIMULATE_ONLY) {
        // Change file mode of mod directory and files inside
        $finalfiles = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($finalpath));
        foreach($finalfiles as $file) {
            chmod($file, MODE);
        }

        if(file_exists($finalpath . SEP . $modslug . '-' . $version . '.zip')) {
            return true;
        } else {
            return false;
        }
    } else {
        // Always return true on a simulation run
        return true;
    }
}

upload($path, $modslug, $version, $file, $filetype, $custom);
writeToDatabase($path, $modslug, $version);

?>