<!DOCTYPE html>
<html lang="en">
    <head>
        <?php define('TITLE', 'Basic Solder Changelog Maker'); require '../../common.php';
            require_once SITE_ROOT . 'includes/header.php';
        ?>
    </head>
    <body>
        <?php include SITE_ROOT . 'includes/menu.php'; ?>
        <div class="container padding-bottom-md">
            <?php

            // Get POST data and trim input
            $base_url = trim($_POST['api']);
            $pack = trim($_POST['modslug']);
            $v1 = trim($_POST['oldvn']); # Old version
            $v2 = trim($_POST['newvn']); # New version
            $showUpdated = (isset($_POST['show-updated'])) ? trim($_POST['show-updated']) : 0;
            $showAdded = (isset($_POST['show-added'])) ? trim($_POST['show-added']) : 0;
            $showRemoved = (isset($_POST['show-removed'])) ? trim($_POST['show-removed']) : 0;

            // Sanitize input with some basic filters
            $base_url = filter_var($base_url, FILTER_SANITIZE_URL);
            $pack = filter_var($pack, FILTER_SANITIZE_STRING);
            $v1 = filter_var($v1, FILTER_SANITIZE_STRING);
            $v2 = filter_var($v2, FILTER_SANITIZE_STRING);
            $showUpdated = filter_var(intval($showUpdated), FILTER_SANITIZE_NUMBER_INT);
            $showAdded = filter_var(intval($showAdded), FILTER_SANITIZE_NUMBER_INT);
            $showRemoved = filter_var(intval($showRemoved), FILTER_SANITIZE_NUMBER_INT);

            setcookie('_api', $base_url, time() + 60 * 60 * 24 * 182, '/tools/mkchangelog/', 'flawedspirit.com', false, true);
            setcookie('_modslug', $pack, time() + 60 * 60 * 24 * 182, '/tools/mkchangelog/', 'flawedspirit.com', false, true);

            // Add trailing slashes to each URL segment if user did not add them
            if(substr($base_url, -1) != "/") {
                $base_url = $base_url . "/";
            }
            if(substr($pack, -1) != "/") {
                $pack = $pack . "/";
            }

            // Give a value to v1 if user left it blank
            if(empty($v1)) {
                $v1 = "No Build";
            }

            $url = $base_url . $pack;

            $old_state = json_decode(file_get_contents($url . $v1), true);
            $new_state = json_decode(file_get_contents($url . $v2), true);
            $http_status = $http_response_header[0];

            $old = getModArray($old_state);
            $new = getModArray($new_state);

            $added = array_diff_key($new, $old);
            $removed = array_diff_key($old, $new);
            $updated = array_diff($new, $old);

            $pack_name = json_decode(file_get_contents($url), true);
            $pack_name = $pack_name['display_name'];

            // Status codes
            $error = array();
            if(empty($base_url)) {
                $error[] = "The Solder API was not entered.";
            }

            if(empty($pack)) {
                $error[] = "The modpack slug was not entered.";
            }

            if(empty($v2)) {
                $error[] = "The current build number you are comparing to must be entered.";
            }

            if(!empty($v2) && $new == $old) {
                $error[] = "No data was returned for the provided build number(s).";
            }

            if(empty($showUpdated) && empty($showAdded) && empty($showRemoved)) {
                $error[] = "All data types are set to hidden. Try enabling one of them.";
            }

            if(!empty($http_status) && !preg_match('/[2-3][0-9]+/', substr($http_response_header[0], 9, 3))) {
                $error[] = "The Solder repository responded with a non-OK status: $http_status";
            }

            echo "<h1>Changelog</h1>";
            echo "<h2>$pack_name ($v1 &rarr; $v2)</h1>";

            echo "<div class=\"btn-toolbar\">";
            echo "<button class=\"btn btn-default\" type=\"submit\" onclick=\"window.history.back();\"><span class=\"glyphicon glyphicon-arrow-left\"></span> Back</button>";
            if(!count($error)) {
                echo "<button class=\"btn btn-info\" type=\"button\" onclick=\"$('html, body').animate({scrollTop: $('#code').offset().top - 60}, 500);\">Get HTML</button>";
            }
            echo "</div>";

            // Preview the page
            if(!empty($updated) && $showUpdated == 1) {
                echo "<h2>Updated</h2>";
                echo "<table class=\"table\">";
                echo "<tr><th>Mod</th><th>Old Version</th><th>New Version</th>";
                foreach($updated as $name => $version) {
                        $oldVersion = (isset($old[$name])) ? $old[$name] : '&mdash;';
                        $newVersion = (isset($new[$name])) ? $new[$name] : '$mdash;';
                    echo "<tr><td width=\"50%\">$name</td><td width=\"25%\">$oldVersion</td><td width=\"25%\"><span class=\"chlog-updated\">$newVersion</span></td></tr>";
                }
                echo "</table>";
            }
            
            if(!empty($added) && $showAdded == 1) {
                echo "<h2>Added</h2>";
                echo "<table class=\"table\">";
                echo "<tr><th>Mod</th><th>Version</th></tr>";
                foreach($added as $name => $version) {
                    echo "<tr><td width=\"50%\">$name</td><td width=\"50%\"><span class=\"chlog-added\">$version</span></td></tr>";
                }
                echo "</table>";
            }

            if(!empty($removed) && $showRemoved == 1) {
                echo "<h2>Removed</h2>";
                echo "<table class=\"table\">";
                echo "<tr><th>Mod</th><th>Version</th></tr>";
                foreach($removed as $name => $version) {
                    echo "<tr><td width=\"50%\">$name</td><td width=\"50%\"><span class=\"chlog-removed\">$version</span></td></tr>";
                }
                echo "</table>";
            }

            if(!count($error)) {
                echo "<button class=\"btn btn-default top\" type=\"submit\" >Top of Page <span class=\"glyphicon glyphicon-arrow-up\"></span></button>";
            }

            // Print the source code of page
            echo "<h2 id=\"code\">Get the code</h2>";
            echo "<span class=\"code\"><p>";

            if(count($error)) {
                echo "There were some issues. They can be found below:";
                foreach($error as $message) {
                    echo "<span class=\"sr-only\">Error:</span>";
                    echo "<p class=\"text-danger\">&mdash; $message</p>";
                }
            }

            if((!empty($updated) || !empty($added) || !empty($removed)) && !count($error)) {
                echo "<textarea class=\"form-control chlog\" id=\"output\" rows=\"20\" readonly>";
                if(!empty($updated) && $showUpdated == 1) {
                    echo htmlentities("<h2>Updated</h2>\n");
                    echo htmlentities("<table>\n");
                    echo htmlentities("\t<tr><th>Mod</th><th>Old Version</th><th>New Version</th></tr>\n");
                    foreach($updated as $name => $version) {
                            $oldVersion = (isset($old[$name])) ? $old[$name] : '&mdash;';
                            $newVersion = (isset($new[$name])) ? $new[$name] : '&mdash;';
                        echo htmlentities("\t<tr><td width=\"50%\">$name</td><td width=\"25%\">$oldVersion</td><td width=\"25%\"><span class=\"chlog-updated\">$newVersion</span></td></tr>\n");
                    }
                    echo htmlentities("</table>\n");
                }
                
                if(!empty($added) && $showAdded == 1) {
                    echo htmlentities("<h2>Added</h2>\n");
                    echo htmlentities("<table>\n");
                    echo htmlentities("\t<tr><th>Mod</th><th>Version</th></tr>\n");
                    foreach($added as $name => $version) {
                        echo htmlentities("\t<tr><td>$name</td><td width=\"50%\"><span class=\"chlog-added\">$version</span></td></tr>\n");
                    }
                    echo htmlentities("</table>\n");
                }

                if(!empty($removed) && $showRemoved == 1) {
                    echo htmlentities("<h2>Removed</h2>\n");
                    echo htmlentities("<table>\n");
                    echo htmlentities("\t<tr><th>Mod</th><th>Version</th></tr>\n");
                    foreach($removed as $name => $version) {
                        echo htmlentities("\t<tr><td>$name</td><td width=\"50%\"><span class=\"chlog-removed\">$version</span></td></tr>\n");
                    }
                    echo htmlentities("</table>\n");
                }
                echo "</textarea>";
                echo "</p></span>";
            }

            function getModArray($jsonObj) {
                $mods = array();

                foreach((array) $jsonObj['mods'] as $mod) {
                    $mods[$mod['name']] = $mod['version'];
                }
                return $mods;
            }

            if(!count($error)): ?>
                <div class="panel panel-primary" role="note">
                    <div class="panel-heading">Note</div>
                    <div class="panel-body">
                        The HTML result is provided "as-is" with no additional CSS support. You will need to provide your own styling to fully integrate it into your site layout.
                    </div>                    
                </div>
            <?php endif; ?>
        </div>
        <?php require_once SITE_ROOT . 'includes/footer.php'; ?>
    </body>
</html>