import crafttweaker.item.IItemStack;

#modloaded akashictome

// =============================================================
// Icehenge 2 -- ice2_starting_inventory.zs
// =============================================================

print("Initializing 'ice2_starting_inventory.zs'...");

// Akashic Tome
var fullTome = <akashictome:tome>.withTag(
    {
        "akashictome:is_morphing": 1 as byte,
        "akashictome:data": {
            tconstruct: {
                id: "tconstruct:book",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "tconstruct"
                },
                Damage: 0 as short
            },
            industrialforegoing: {
                id: "industrialforegoing:book_manual",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "industrialforegoing"
                },
                Damage: 0 as short
            },
            astralsorcery: {
                id: "astralsorcery:itemjournal",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "astralsorcery"
                },
                Damage: 0 as short
            },
            immersiveengineering: {
                id: "immersiveengineering:tool",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "immersiveengineering"
                },
                Damage: 3 as short
            },
            rftools: {
                id: "rftools:rftools_manual",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "rftools"
                },
                Damage: 0 as short
            },
            rustic: {
                id: "rustic:book",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "rustic"
                },
                Damage: 0 as short
            },
            cyclicmagic: {
                id: "guideapi:cyclicmagic-guide",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "cyclicmagic"
                },
                Damage: 0 as short
            },
            botania: {
                id: "botania:lexicon",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "botania"
                },
                Damage: 0 as short
            },
            draconicevolution: {
                id: "draconicevolution:info_tablet",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "draconicevolution"
                },
                Damage: 0 as short
            },
            extrautils2: {
                id: "extrautils2:book",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "extrautils2"
                },
                Damage: 0 as short
            },
            thermalfoundation: {
                id: "thermalfoundation:tome_lexicon",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "thermalfoundation"
                },
                Damage: 0 as short
            },
            bloodmagic: {
                id: "guideapi:bloodmagic-guide",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "bloodmagic"
                },
                Damage: 0 as short
            },
            actuallyadditions: {
                id: "actuallyadditions:item_booklet",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "actuallyadditions"
                },
                Damage: 0 as short
            },
            opencomputers: {
                id: "opencomputers:tool",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "opencomputers"
                },
                Damage: 4 as short
            },
            cookingforblockheads: {
                id: "cookingforblockheads:recipe_book",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "cookingforblockheads"
                },
                Damage: 1 as short
            },
            xnet: {
                id: "xnet:xnet_manual",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "xnet"
                },
                Damage: 0 as short
            },
            rftoolscontrol: {
                id: "rftoolscontrol:rftoolscontrol_manual",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "rftoolscontrol"
                },
                Damage: 0 as short
            },
            rftoolsdim: {
                id: "rftoolsdim:rftoolsdim_manual",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "rftoolsdim"
                },
                Damage: 0 as short
            },
            rftools1: {
                id: "rftools:rftools_shape_manual",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "rftools1"
                },
                Damage: 0 as short
            },            
            forestry: {
                id: "forestry:book_forester",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "forestry"
                },
                Damage: 0 as short
            },
            openblocks: {
                id: "openblocks:info_book",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "openblocks"
                },
                Damage: 0 as short
            },
            conarm: {
                id: "conarm:book",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "conarm"
                },
                Damage: 0 as short
            },
            guideapi: {
                id: "guideapi:inventorygenerators-guide_book",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "guideapi"
                },
                Damage: 0 as short
            },
            envtech: {
                id: "valkyrielib:guide",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "envtech"
                },
                Damage: 0 as short
            },
            theoneprobe: {
                id: "theoneprobe:probenote",
                Count: 1 as byte,
                tag: {
                    "akashictome:definedMod": "theoneprobe"
                },
                Damage: 0 as short
            }
        }
    }   
);

// Note default books in their tooltips
var guideBooks = [
    <tconstruct:book>,
    <industrialforegoing:book_manual>,
    <astralsorcery:itemjournal>,
    <immersiveengineering:tool>,
    <rftools:rftools_manual>,
    <rustic:book>,
    <guideapi:cyclicmagic-guide>,
    <botania:lexicon>,
    <draconicevolution:info_tablet>,
    <extrautils2:book>,
    <thermalfoundation:tome_lexicon>,
    <guideapi:bloodmagic-guide>,
    <actuallyadditions:item_booklet>,
    <opencomputers:tool>,
    <cookingforblockheads:recipe_book>,
    <xnet:xnet_manual>,
    <rftoolscontrol:rftoolscontrol_manual>,
    <rftoolsdim:rftoolsdim_manual>,
    <rftools:rftools_shape_manual>,
    <forestry:book_forester>,
    <openblocks:info_book>,
    <conarm:book>,
    <valkyrielib:guide>,
    <theoneprobe:probenote>
] as IItemStack[];

for book in guideBooks {
    book.addTooltip(format.aqua("This guide is included in the \'default\' Akashic Tome."));
}

// Add the full book to JEI
mods.jei.JEI.addItem(fullTome);
fullTome.addTooltip(format.aqua("Packed with mod guides and manuals to aid you on your journey!"));

// Add simple recipe to get a new one
recipes.addShapeless(fullTome, [<minecraft:dirt>]);

// Starting inventory
mods.initialinventory.InvHandler.addStartingItem(fullTome);
mods.initialinventory.InvHandler.addStartingItem(<ancientwarfarenpc:food_bundle> * 8);
